*--- curBase Class
*--- Base class for Cursor Object
DEFINE CLASS curBase as Cursor
	
	*--- Specify that our Database
	*--- for all cursors will be
	*--- TestData.dbc
	Database = "TestData.dbc"
	
	*--- Setup the Cursor Base Class
	*--- to load empty structures
	NoDataOnLoad = .T.
	
	*--- Set the buffering to table buffering
	BufferModeOverride = 5
	
	*--- Init Event
	*--- Executes when the object is Instantiated
	PROCEDURE Init
		
		*--- If this the first Cursor Object Loading
		*--- Populate the Initial Selected Alias
		IF EMPTY(This.Parent.InitialSelectedAlias)
			This.Parent.InitialSelectedAlias = This.Alias
		ENDIF
		
		*--- Populate the Database property of the Parent Object
		This.Parent.cDatabase = This.Database
		
	ENDPROC
	
ENDDEFINE